"use client";
import { useState, useRef, useEffect } from "react";
import {
    Sun, Moon, Grid, X, Camera, Plus, LogOut,
    ChevronDown, ChevronUp, Home, Check, ChevronRight, Loader2
} from "lucide-react";
import { cn } from "@/lib/utils";
import Link from "next/link";
// import { useAuth } from "@/context/AuthContext"
import { useAuth } from "@/context/AuthContext"
interface Account {
    email: string;
    name: string;
    image?: string;
}
import { useRouter } from 'next/navigation';

// const user = {
//     first_name: 'Ananda',
//     primary_email: 'ananda@gmail.com'
// }


const API_URL = process.env.NEXT_PUBLIC_API_BASE_URL

interface AccountSwitcherProps {
    primaryAccount: Account;
    theme: string;
    toggleTheme: () => void;
}

export default function AccountSwitcher({ primaryAccount, theme, toggleTheme }: AccountSwitcherProps) {
    const [isOpen, setIsOpen] = useState(false);
    const [showMore, setShowMore] = useState(true);
    const [otherAccounts, setOtherAccounts] = useState<Account[]>([]);
    const menuRef = useRef<HTMLDivElement>(null);
    // const { user, setUser, logout } = useAuth()
    const { user, loading, refreshUser, logout } = useAuth()
    const router = useRouter()


    const handleLogOut = () => {
        logout(); 
        // router.push("/login")
    }
    // Fetch accounts from local storage on mount
    useEffect(() => {
        const saved = localStorage.getItem("saved_accounts");
        if (saved) {
            try {
                const parsed: Account[] = JSON.parse(saved);
                // Filter out the primary account if it exists in the list to avoid duplicates
                setOtherAccounts(parsed.filter(acc => acc.email !== primaryAccount.email));
            } catch (e) {
                console.error("Failed to parse saved_accounts", e);
            }
        }
    }, [primaryAccount.email]);

    // Close when clicking outside
    useEffect(() => {
        const handler = (e: MouseEvent) => {
            if (menuRef.current && !menuRef.current.contains(e.target as Node)) setIsOpen(false);
        };
        document.addEventListener("mousedown", handler);
        return () => document.removeEventListener("mousedown", handler);
    }, []);

    const getInitial = (name: string) => name.charAt(0).toUpperCase();

    return (
        <div className="flex items-center gap-1 relative" ref={menuRef}>
            {/* Utility Buttons */}
            {/* <button onClick={toggleTheme} className="p-2 hover:bg-accent rounded-full text-muted-foreground transition-colors">
        {theme === "dark" ? <Sun size={20} /> : <Moon size={20} />}
      </button> */}

            {/* <button className="hidden sm:flex p-2 hover:bg-accent rounded-full text-muted-foreground">
        <Grid size={20} />
      </button> */}

            {/* Main Avatar Toggle */}
            {loading && <div
                className="ml-2 w-8 h-8 rounded-full bg-sidebar-primary flex items-center justify-center text-sm text-white font-medium cursor-pointer border border-border shadow-sm hover:ring-4 hover:ring-sidebar-primary/20 transition-all"
            >
                <Loader2 className="h-8 w-8 animate-spin text-sidebar-primary" />
            </div>}


            {!loading && <div
                onClick={() => setIsOpen(!isOpen)}
                className="ml-2 w-8 h-8 rounded-full bg-sidebar-primary flex items-center justify-center text-sm text-white font-medium cursor-pointer border border-border shadow-sm hover:ring-4 hover:ring-sidebar-primary/20 transition-all"
            >
                {/* {getInitial(user?.first_name)} */}

                {!user.profile_picture && user.first_name.toUpperCase().charAt(0)}
                {user.profile_picture && <img src={`${user.profile_picture}`} alt="Profile Picture" className="rounded-full" />}
            </div>}



            {/* --- GOOGLE STYLE MENU --- */}
            {isOpen && user && (
                <div className="absolute overflow-y-scroll max-h-[80vh] top-12 right-0 w-[350px] bg-[#f0f4f9] dark:bg-[#1e1f20] rounded-[28px] shadow-2xl z-[100] border border-border/50 p-2 animate-in fade-in zoom-in-95 duration-200">

                    {/* Header Card (Primary Account) */}
                    <div className="bg-card rounded-[24px] p-4 text-center relative shadow-sm">
                        <button onClick={() => setIsOpen(false)} className="absolute right-4 top-4 text-muted-foreground hover:bg-accent p-1.5 rounded-full transition-colors">
                            <X size={18} />
                        </button>

                        <p className="text-sm font-medium mb-4 text-foreground/80">{user?.primary_email}</p>

                        <div className="relative w-20 h-20 mx-auto group">
                            <div className="w-full h-full rounded-full bg-green-700 flex items-center justify-center text-3xl text-white">
                                {/* {getInitial(user?.first_name)} */}

                                {!user.profile_picture && user.first_name.toUpperCase().charAt(0)}
                                {user.profile_picture && <img src={`${user.profile_picture}`} alt="Profile Picture" className="rounded-full" />}
                            </div>
                            <div className="absolute bottom-0 right-0 p-1.5 bg-card border border-border rounded-full shadow-md cursor-pointer hover:bg-accent">
                                <Link href="/settings">
                                    <Camera size={14} />
                                </Link>
                            </div>
                        </div>

                        <h2 className="text-xl font-normal mt-3 text-foreground">Hi, {user?.first_name!}</h2>

                        <button className="mt-4 px-6 py-2 border border-border rounded-full text-sm font-semibold hover:bg-sidebar-primary/5 transition-colors text-sidebar-primary">
                            <Link href="/settings">
                                Manage your Account
                            </Link>
                        </button>
                    </div>

                    {/* Secondary Accounts List */}
                    <div className="mt-2 bg-card rounded-[24px] overflow-hidden shadow-sm">
                        <button
                            onClick={() => setShowMore(!showMore)}
                            className="w-full flex items-center justify-between p-4 hover:bg-accent/50 transition-colors"
                        >
                            <span className="text-sm font-medium">Other accounts</span>
                            {showMore ? <ChevronUp size={18} /> : <ChevronDown size={18} />}
                        </button>

                        {showMore && (
                            <div className="pb-2">
                                {otherAccounts.map((acc, i) => (
                                    <div key={i} className="">
                                        <Link href={`/login?auth=${i + 1}`}
                                            className="flex items-center justify-between px-4 py-3 hover:bg-accent/40 cursor-pointer border-t border-border/40 group"
                                        >
                                            <div className="flex items-center gap-3">
                                                <div className="w-9 h-9 rounded-full bg-muted flex items-center justify-center text-muted-foreground text-sm font-bold">
                                                    {getInitial(acc.name)}
                                                </div>
                                                <div className="text-left">
                                                    <p className="text-sm font-semibold leading-none text-foreground">{acc.name}</p>
                                                    <p className="text-xs text-muted-foreground mt-1">{acc.email}</p>
                                                </div>
                                            </div>
                                            <ChevronRight size={16} className="text-muted-foreground opacity-0 group-hover:opacity-100 transition-opacity" />
                                        </Link>
                                    </div>
                                ))}

                                <div className="flex items-center gap-3 px-4 py-3 hover:bg-accent/40 cursor-pointer border-t border-border/40">
                                    <div className="w-9 h-9 flex items-center justify-center">
                                        <Plus size={20} className="text-muted-foreground" />
                                    </div>
                                    <Link href="/login" >
                                        <span className="text-sm font-medium">Add another account</span>
                                    </Link>
                                </div>

                                <button onClick={handleLogOut} className="w-full">
                                    <div className="flex w-full items-center gap-3 px-4 py-3 hover:bg-accent/40 cursor-pointer border-t border-border/40">
                                        <div className="w-9 h-9 flex items-center justify-center">
                                            <LogOut size={20} className="text-muted-foreground" />
                                        </div>
                                        <span className="text-sm font-medium">Sign out</span>
                                    </div>
                                </button>
                            </div>
                        )}
                    </div>

                    {/* Footer */}
                    <div className="flex justify-center gap-4 py-4 text-[10px] text-muted-foreground font-medium uppercase tracking-tighter">
                        <span className="hover:underline cursor-pointer">Privacy</span>
                        <span>•</span>
                        <span className="hover:underline cursor-pointer">Terms</span>
                    </div>
                </div>
            )}
        </div>
    );
}